// Fileini.cpp: implementation of the CFileini class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SetSoPin.h"
#include "Fileini.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFileini::CFileini()
{
   sPath.Empty();
   sFilename.Empty();
   sPathFilename.Empty();

}

CFileini::~CFileini()
{

}


BOOL CFileini::OpenFileini()
{
    if(sPath.IsEmpty() || sFilename.IsEmpty() )
	{
	  return FALSE;
	}
     
    sPathFilename=sPath+sFilename;

	BOOL ret=0;
	CFileFind filefind;
	ret=filefind.FindFile(sPathFilename);
    
	//ڵĻһINI ļ
	if(! ret) 
	{ 
		HANDLE hFile; 
        hFile = CreateFile(sPathFilename,  
			GENERIC_READ,             
			FILE_SHARE_READ,          
			NULL,                      
			CREATE_NEW,             
			FILE_ATTRIBUTE_NORMAL,     
			NULL);               
		
		if (hFile == INVALID_HANDLE_VALUE) 
		{ 
			return FALSE;
		} 
		CloseHandle(hFile); 
	} 
	

	return TRUE;
} 

void CFileini::SetIniPath(CString spPath)
{
    sPath=spPath;
	return;
}

void CFileini::SetIniFilename(CString spFilename)
{
    sFilename=spFilename;   
	return;
}

void CFileini::GetKeyVar(CString spSectionname,CString spKey,CString & spVar)
{
	if(spKey.IsEmpty()) 
	{		
		spVar.Empty();		
		return;   
	}
   GetPrivateProfileString(spSectionname,spKey,"NULL",(char *)spVar.GetBuffer(0),MAX_PATH,sPathFilename);


   return ;
}

void CFileini::WriteKeyVar(CString spSectionname,CString spKey,CString spVar)
{
	if(spKey.IsEmpty()) 
	{		
		spVar.Empty();		
		return;   
	}

	WritePrivateProfileString(spSectionname,spKey,(char *)spVar.GetBuffer(0),sPathFilename);
	
	return;
}

/*
spKeyֵΪյĻĬдһڱ
INIļѾ ô򽫲
INIļûڣ һµĽ
*/
void CFileini::CreateKey(CString spSectionname,CString spKey)
{   

    WritePrivateProfileSection(spSectionname,spKey,sPathFilename);
    return ;
}