// SetSoPinDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SetSoPin.h"
#include "SetSoPinDlg.h"
#include "UpdataUidDlg.h"
#include "Fileini.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define INFO_BUFFER_SIZE 100
HDEVNOTIFY hdevnotify1;

STARTUPINFO g_si;
PROCESS_INFORMATION g_pi;
DWORD g_res;
TCHAR g_szPath[INFO_BUFFER_SIZE] = {0};
DWORD g_PathLen=0;
TCHAR g_Info[1000]={0};

CString strtmp;

BOOL DoRegisterDeviceInterface(HWND hWnd,
							   GUID InterfaceClassGuid,
							   HDEVNOTIFY* hDevNotify)
/*
Routine Description:
Registers for notification of changes in the device interfaces for
the specified interface class GUID. 

Parameters:
InterfaceClassGuid - The interface class GUID for the device 
interfaces. 

hDevNotify - Receives the device notification handle. On failure, 
this value is NULL.

Return Value:
If the function succeeds, the return value is TRUE.

If the function fails, the return value is FALSE.
*/
{
    DEV_BROADCAST_DEVICEINTERFACE NotificationFilter;
    DWORD Err;
	
    ZeroMemory(&NotificationFilter, sizeof(NotificationFilter));
    NotificationFilter.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
    NotificationFilter.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
    NotificationFilter.dbcc_classguid = InterfaceClassGuid;
	
    *hDevNotify = RegisterDeviceNotification(hWnd,
		&NotificationFilter,
		DEVICE_NOTIFY_WINDOW_HANDLE
		//DEVICE_NOTIFY_ALL_INTERFACE_CLASSES
		//DEVICE_NOTIFY_SERVICE_HANDLE
		);
	
    if (!*hDevNotify)
    {
        Err = GetLastError();
        //printf("RegisterDeviceNotification failed: %lx.\n", Err);
        return FALSE;
    } 
	
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
	
	// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA
	
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL
	
	// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
ON_WM_CTLCOLOR()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetSoPinDlg dialog

CSetSoPinDlg::CSetSoPinDlg(CWnd* pParent /*=NULL*/)
: CDialog(CSetSoPinDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetSoPinDlg)
	m_pid = _T("");
	m_oldpin = _T("");
	m_dowhile = FALSE;
	m_olduid = _T("");
	m_sopinnum = _T("");
	m_upinnum = _T("");
	m_readw = FALSE;
	m_pidflg = FALSE;
	m_readwflg = FALSE;
	m_sopinflg = FALSE;
	m_upinflg = FALSE;
	m_newupin = _T("");
	m_seed = _T("");
	m_oldpid = _T("");
	m_SopinSeed = _T("");
	m_Batchflg = FALSE;
	m_hid = _T("");
	//}}AFX_DATA_INIT
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSetSoPinDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetSoPinDlg)
	DDX_Control(pDX, IDC_LIST_RESULT, m_List);
	DDX_Control(pDX, BUTTON_SET, m_btnSet);
	DDX_Text(pDX, EDIT_PID, m_pid);
	DDV_MaxChars(pDX, m_pid, 8);
	DDX_Text(pDX, EDIT_OLDSOPIN, m_oldpin);
	DDV_MaxChars(pDX, m_oldpin, 16);
	DDX_Text(pDX, EDIT_OLDUID, m_olduid);
	DDV_MaxChars(pDX, m_olduid, 16);
	DDX_Text(pDX, IDC_EDITSOPINNUM, m_sopinnum);
	DDX_Text(pDX, IDC_EDITUPINNUM, m_upinnum);
	DDX_Check(pDX, IDC_CHECKREADW, m_readw);
	DDX_Check(pDX, IDC_CHECKPIDFLG, m_pidflg);
	DDX_Check(pDX, IDC_CHECKREADWFLG, m_readwflg);
	DDX_Check(pDX, IDC_CHECKSOPINFLG, m_sopinflg);
	DDX_Check(pDX, IDC_CHECKUSERPIN, m_upinflg);
	DDX_Text(pDX, EDIT_NEWUID, m_newupin);
	DDV_MaxChars(pDX, m_newupin, 16);
	DDX_Text(pDX, EDIT_SEED, m_seed);
	DDV_MaxChars(pDX, m_seed, 51);
	DDX_Text(pDX, EDIT_OLDPID, m_oldpid);
	DDV_MaxChars(pDX, m_oldpid, 8);
	DDX_Text(pDX, EDIT_SOPIN_SEED, m_SopinSeed);
	DDV_MaxChars(pDX, m_SopinSeed, 51);
	DDX_Check(pDX, IDC_Batch, m_Batchflg);
	DDX_Text(pDX, IDC_EDIT_HID, m_hid);
	DDV_MaxChars(pDX, m_hid, 16);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetSoPinDlg, CDialog)
//{{AFX_MSG_MAP(CSetSoPinDlg)
ON_WM_SYSCOMMAND()
ON_WM_PAINT()
ON_WM_QUERYDRAGICON()
ON_BN_CLICKED(BUTTON_EXIT, OnExit)
ON_BN_CLICKED(BUTTON_SET, OnSet)
ON_EN_CHANGE(EDIT_OLDSOPIN, OnChangeOldsopin)
ON_EN_CHANGE(EDIT_SEED, OnChangeSeed)
ON_BN_CLICKED(BUTTON_RESET, OnReset)
ON_BN_CLICKED(IDC_BUTHelp, OnButUpdataUid)
ON_EN_CHANGE(IDC_EDITSOPINNUM, OnChangeEditsopinnum)
ON_BN_CLICKED(IDC_BUTHOISTRY, OnButhoistry)
ON_BN_CLICKED(BUTTON_RESET2, OnUpUpin)
ON_WM_CTLCOLOR()
ON_EN_CHANGE(EDIT_OLDPID, OnChangeOldpid)
ON_EN_CHANGE(EDIT_OLDUID, OnChangeOlduid)
ON_EN_CHANGE(EDIT_NEWUID, OnChangeNewuid)
ON_EN_CHANGE(EDIT_SOPIN_SEED, OnChangeSopinSeed)
ON_EN_CHANGE(IDC_EDITUPINNUM, OnChangeEditupinnum)
ON_BN_CLICKED(IDC_CHECKPIDFLG, OnCheckpidflg)
ON_BN_CLICKED(IDC_CHECKSOPINFLG, OnChecksopinflg)
ON_BN_CLICKED(IDC_CHECKUSERPIN, OnCheckuserpin)
ON_BN_CLICKED(IDC_CHECKREADWFLG, OnCheckreadwflg)
ON_BN_CLICKED(IDC_Batch, OnBatch)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetSoPinDlg message handlers

BOOL CSetSoPinDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// Add "About..." menu item to system menu.
	
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);
	
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	//////////////////////////////////////////////////////////////////////////
	///////////////////////עUSBϢ///////////////////////
	GUID tmpGuid;
    LONG tmpdata = 0;
    BOOL bReturn;
    //{a5dcbf10-6530-11d2-901f-00c04fb951ed} usb guid
    tmpGuid.Data1 = 0xa5dcbf10;
    tmpGuid.Data2 = 0x6530;
    tmpGuid.Data3 = 0x11d2;
    tmpGuid.Data4[0] = 0x90;
    tmpGuid.Data4[1] = 0x1f;
    tmpGuid.Data4[2] = 0;
    tmpGuid.Data4[3] = 0xc0;
    tmpGuid.Data4[4] = 0x4f;
    tmpGuid.Data4[5] = 0xb9;
    tmpGuid.Data4[6] = 0x51;
    tmpGuid.Data4[7] = 0xed;
	
	
    bReturn = DoRegisterDeviceInterface(this->GetSafeHwnd(),
		tmpGuid,
		&hdevnotify1);
    if (bReturn != TRUE)
	{
		//AfxMessageBox("Register USB error");
    }
	else
    {
		//AfxMessageBox("Register Success!");
    }
	
	DWORD i=0;
	//////////////ע/////////////////
	//TCHAR szAppName[_MAX_PATH] = TEXT("\\peghelp.exe");
	LONG lRetCode= 0;
	TCHAR cReg[INFO_BUFFER_SIZE] = {0};
	TCHAR cTempPath[INFO_BUFFER_SIZE] = {0};
	memset(g_szPath,0,INFO_BUFFER_SIZE);
	DWORD dwBufLen=INFO_BUFFER_SIZE;
	HKEY hKeyIE = 0;
	
	int iRegLen = lstrlen("HTTP\\shell\\open\\command\\");
	
	memcpy(cReg, "HTTP\\shell\\open\\command\\", iRegLen);
	
	lRetCode = RegOpenKeyEx(HKEY_CLASSES_ROOT,
		cReg,
		0,
		KEY_QUERY_VALUE,
		&hKeyIE);
	
	lRetCode = RegQueryValueEx(hKeyIE, "", NULL, NULL,
		(LPBYTE) cTempPath, &dwBufLen);
	
	RegCloseKey(hKeyIE);
	
	/*memset(g_Info,0,1000);
	memcpy(g_Info, "haha1",5);
	memcpy(g_Info+5,cTempPath,dwBufLen); 
	//OutputDebugString(g_Info);
	FILE* fpw=NULL;
	fopen("testinfo","wb");
	fwrite(cTempPath, sizeof(BYTE), dwBufLen, fpw);
	fclose(fpw);*/
	
	
	if(cTempPath[0] == 0x22)
	{
		for(i=1; i<dwBufLen; ++i)
		{
			if(cTempPath[i] == 0x22)
				break;
		}
		
		memcpy(g_szPath, cTempPath+1, i-1);
		g_PathLen = i-1;
	}
	
	//PostMessage(WM_SYSCOMMAND,SC_MAXIMIZE,FALSE);   
	//AfxGetMainWnd()->ShowWindow(SW_HIDE);
	//	AfxGetMainWnd()->ShowWindow(SW_SHOWNORMAL);
	
	//	ModifyStyleEx(WS_EX_APPWINDOW,WS_EX_TOOLWINDOW);  
	//	WINDOWPLACEMENT   wp;  
	//	wp.length=sizeof(WINDOWPLACEMENT);  
	//	wp.flags=WPF_RESTORETOMAXIMIZED;  
	//	wp.showCmd=SW_SHOWNORMAL;//SW_HIDE;  
	// 	SetWindowPlacement(&wp);   
	//////////////////////////////////////////////////////////////////////////
	
	
	//Ĭϵֵ
	UpdateData(TRUE);
    m_oldpid.Format("FFC5EB78");
    m_oldpin.Format("FFFFFFFFFFFFFFFF"); 
    m_olduid.Format("FFFFFFFFFFFFFFFF");    
    m_newupin.Format("");
    m_seed.Format("");
	//    m_newpid.Format("");
	
	m_sopinnum.Format("0");
	m_upinnum.Format("0");
	
	UpdateData(FALSE);
	
	//INIļ
    DWORD cchCurDir=MAX_PATH; 
	LPTSTR lpszCurDir; 
	TCHAR tchBuffer[MAX_PATH];
	lpszCurDir = tchBuffer;	
	
	GetCurrentDirectory(cchCurDir, lpszCurDir);
	
	fileini.SetIniPath(lpszCurDir);
	fileini.SetIniFilename("\\History.ini");
	fileini.OpenFileini();
	
	m_Batchflg = FALSE;

	//ToolTips
	ToolTips();

	//==========
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetSoPinDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSetSoPinDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting
		
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		
		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		
		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSetSoPinDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSetSoPinDlg::OnExit() 
{
	CDialog::OnOK();
}

BOOL CSetSoPinDlg::OpenDevice()
{
   	// 
	
	int tokenCount;
	unsigned long ret = ET_SUCCESS;
	unsigned char pucSN[8]={0};
	CString strtmp;
	CString strVal;
	
	ret = et_FindToken(longPid,&tokenCount);
	
	if(ET_SUCCESS!=ret)
	{
		MessageBox("ҲָET99! ӲPIDǷȷ","OpenEt99",MB_OK|MB_ICONSTOP);
		//m_List.AddString("ҲָET99! ӲPIDǷȷ");
		//UpdateWindow();
		return FALSE;
	}
	else
	{
		if(1!=tokenCount)
		{// YUHZ[11/27/2006] ýҵET99ʾ˵ùһֻʼһET99
			char temp[10]={0};
			sprintf(temp,"%d",tokenCount);
			char txt[MAX_PATH]={0};
			lstrcat(txt,"ҵ");
			lstrcat(txt,temp);
			lstrcat(txt,"ָET99һֻܳʼһET99");
			MessageBox(txt,"OpenEt99",MB_OK|MB_ICONSTOP);
			return FALSE;
		}
	}
	
	ret = et_OpenToken(&hET99,longPid,1);
	if(ET_SUCCESS!=ret)
	{
		MessageBox("ET99ʧ!","OpenEt99",MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	//	// YUHZ[11/27/2006]OpenDriver()֤ûPINϲӦõ档⣬ҲǡԸĽOpenDevice()ʲô 
	//	ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
	//
	//	if(ET_SUCCESS!=ret)
	//	{
	//		MessageBox("ûPIN!","OpenEt99",MB_OK|MB_ICONSTOP);
	//		et_CloseToken(hET99);
	//		return FALSE;
	//	}

	//ȡӲк
	ret = et_GetSN(hET99, pucSN);
	if(ET_SUCCESS != ret)
	{
		strtmp.Format("ȡӲкʧ: 0x%X", ret);
		MessageBox(strtmp, "ʾ", MB_OK);
	}
	else
	{
		//MessageBox("ȡӲкųɹ");
		strtmp.Empty();
		for(int i=0; i<8; i++)
		{
			strVal.Format(_T("%02X"), pucSN[i]);
			strtmp+=strVal;
		}
		GetDlgItem(IDC_EDIT_HID)->SetWindowText(strtmp);
	}
	
	return TRUE;
}


void CSetSoPinDlg::OnSet() 
{
	//б
	m_List.ResetContent();
	
	if(!m_Batchflg)
	{
		char chSoPin[17];
		unsigned char newPid[8];
		unsigned long ret = ET_SUCCESS;
		
		if(m_sopinflg)
		{
			if(m_SopinSeed == m_seed)
			{
				if(IDYES!=MessageBox("PIDӺͲSOPINһ,ڰȫ!Ƿ?","InitET99",MB_YESNO))
					return;
			}
		}	
		
		//===========
		
		UpdateData(TRUE);
		// YUHZ[11/27/2006] ע⣡ڲSOPINPIDӦòͬήͰȫԡӦ 
		GetDlgItemText(EDIT_PID,Pid);              //ӲPID
		GetDlgItemText(EDIT_OLDSOPIN,OldSoPin);    //SOPIN
		GetDlgItemText(EDIT_SEED,Seed);            //
		GetDlgItemText(EDIT_OLDUID,Uid);           //ɵû
		GetDlgItemText(EDIT_NEWUID,NewUid);        //µû
		
		memcpy(longPid,Pid.GetBuffer(0),8);
		
		//ϴβµSO PIN µPID
		//	m_newsopin.Empty();
		//	m_newpid.Empty();
		UpdateData(FALSE);
		
		if(m_pidflg || m_sopinflg || m_upinflg ||  m_readwflg)
		{
			//========================ӲPID
			if(m_pidflg)
			{
				if(!OpenDevice())
				{
					return;
				}
				
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","SetTokenPID",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				ret = et_GenPID(hET99,Seed.GetLength(),(unsigned char *)Seed.GetBuffer(0),newPid);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ӲPIDʧ!","SetTokenPID",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{
					char NewChPid[9];
					memcpy(NewChPid,newPid,8);
					//µӲPIDֵ
					memcpy(longPid,newPid,8);
					NewChPid[8]='\0';
					CString CSPid(NewChPid);
					
					//дINIļ			
					fileini.WriteKeyVar("ET99","PID",Seed);
					fileini.WriteKeyVar("ET99","ӲPID",CSPid);
					
					strtmp.Format(">ӲPIDɹ! PID:%s\n", CSPid);
					//SetDlgItemText(IDC_Result, strtmp);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
				}
			}
			
			//=====================================
			
			//================óûPIN
			if(m_sopinflg )
			{
				if(!OpenDevice())
				{
					return;
				}
				
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","OpenEt99",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				ret = et_GenSOPIN(hET99,m_SopinSeed.GetLength(),(unsigned char *)m_SopinSeed.GetBuffer(0),(unsigned char*)chSoPin);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("óûPINʧ!","SetSOPIN",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{   
					chSoPin[16]='\0'; 
					//µSOPIN 
					OldSoPin=chSoPin;
					CString NewSoPin((char *)chSoPin);
					//strtmp.Format("");
					//SetDlgItemText(EDIT_NEWSOPIN,NewSoPin);
					strtmp.Format(">SOPINɹ! SOPIN: %s\n", NewSoPin);
					//SetDlgItemText(IDC_Result, strtmp);
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
					
					//дINIļ				
					fileini.WriteKeyVar("ET99","SOPIN",m_SopinSeed);
					fileini.WriteKeyVar("ET99","SO PIN",NewSoPin);
					
					//MessageBox("óûPINɹ ! ","SetSOPIN",MB_OK|MB_ICONINFORMATION);
				}
				
			}
			
			//==================================
			
			//=================ûPIN
			if(m_upinflg )
			{
				if(!OpenDevice())
				{
					return;
				}
				//			// YUHZ[11/27/2006] ƣet_ChangeUserPIN״̬½УҪ֤ûPIN 
				//			//֤û
				//			ret = et_Verify(hET99,ET_VERIFY_USERPIN,(unsigned char *)Uid.GetBuffer(0));
				//			if(ET_SUCCESS!=ret)
				//			{
				//				MessageBox("ûPIN!","UpUserPIN",MB_OK|MB_ICONSTOP);		
				//				et_CloseToken(hET99);
				//			}
				//			else
				{
					ret = et_ChangeUserPIN(hET99,(unsigned char *)Uid.GetBuffer(0),(unsigned char *)NewUid.GetBuffer(0));
					
					if(ET_SUCCESS!=ret)
					{
						if(ret == ET_NOT_SET_PID)
							MessageBox("㻹ûET99PID!","ChangeUserPin",MB_OK|MB_ICONSTOP);
						else
							MessageBox("ıûPIN!","ChangeUserPin",MB_OK|MB_ICONSTOP);
						et_CloseToken(hET99);
						return;
					}
					
					//дINIļ				
					fileini.WriteKeyVar("ET99","µUser PIN",NewUid);
					
					//MessageBox("ıûPINɹ!","ChangeUserPin",MB_OK);
					strtmp.Format(">ıûPINɹ! ûPIN: %s\n", NewUid);
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);			
				}
				
			}
			
			//==================================
			
			//================
			if(m_readwflg)
			{
				if(!OpenDevice())
				{
					return;
				}
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","OpenEt99",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				BYTE SoPinRetryCount=0;       //SOPINĶд
				BYTE UserPinRetryCount=0;     //UIDĶд
				BOOL ReadOnlyFlag=0;          //ֻ
				
				UpdateData(TRUE);
				
				SoPinRetryCount=atoi(m_sopinnum);
				UserPinRetryCount=atoi(m_upinnum);
				ReadOnlyFlag=m_readw;
				
				if(ReadOnlyFlag) ReadOnlyFlag=ET_USER_READ_ONLY; //ֻ
				
				if((0>SoPinRetryCount)||(15<SoPinRetryCount)||(0>UserPinRetryCount)||(15<UserPinRetryCount)||!(ReadOnlyFlag==0||ReadOnlyFlag==1))
				{
					MessageBox("д!","SetupToken",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				ret = et_SetupToken(hET99,SoPinRetryCount,UserPinRetryCount,ReadOnlyFlag,0);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ET99ʧ!","SetupToken",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{
					char sopincount[5]={0};
					char userpincount[5]={0};
					sprintf(sopincount,"%d",SoPinRetryCount);
					sprintf(userpincount,"%d",UserPinRetryCount);
					fileini.WriteKeyVar("ET99","SO PINԴ",sopincount);
					fileini.WriteKeyVar("ET99","User PINԴ",userpincount);
					if(m_readw)
						fileini.WriteKeyVar("ET99","д","ֻ");
					else
						fileini.WriteKeyVar("ET99","д","ɶд");
					//MessageBox("ET99Գɹ! ","SetupToken",MB_OK|MB_ICONINFORMATION);
					strtmp.Format(">ET99Գɹ!\n");
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
				}
			}
			//====================================
			Sleep(500);
			m_List.AddString("ϸϢ\"ʷ¼\"鿴!");
			UpdateWindow();
	}
	else
	{
		MessageBox("ѡ!","Et99 Setting",MB_OK|MB_ICONINFORMATION);
		return ;
	}
		}
		else
			MessageBox("ʱҪ,ֻ!");	
		
}

void CSetSoPinDlg::OnChangeOldsopin() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnChangeSeed() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	//	CDialog::OnOK();
}

void CSetSoPinDlg::OnReset() 
{
	m_List.ResetContent();
	
	//Ĭϵֵ
	UpdateData(TRUE);
	m_oldpid.Format("FFFFFFFF");
    m_oldpin.Format("FFFFFFFFFFFFFFFF");    
    m_olduid.Format("FFFFFFFFFFFFFFFF");    
    m_newupin.Format("");
    m_seed.Format("");
	//    m_newpid.Format("");
	m_SopinSeed.Format("");
    
	m_sopinnum.Format("0");
	m_upinnum.Format("0");
	
	m_Batchflg = FALSE;
	m_btnSet.SetWindowText(" ");
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnButUpdataUid() 
{   
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CSetSoPinDlg::OnChangeEditsopinnum() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}



void CSetSoPinDlg::OnButhoistry() 
{ 
    ShellExecute(NULL,"open",fileini.sPathFilename,NULL,NULL,SW_SHOWNORMAL);
}

void CSetSoPinDlg::OnUpUpin() 
{
	GetDlgItemText(EDIT_PID,Pid);
	GetDlgItemText(EDIT_OLDSOPIN,OldSoPin);	
	GetDlgItemText(EDIT_OLDUID,Uid);	
	
	if(Uid.IsEmpty())
	{
		::AfxMessageBox("ûPINΪ!");
		return ;
	}
    CUpdataUidDlg UpuidDlg;  
	
	
	memcpy(UpuidDlg.longPid ,Pid.GetBuffer(0),8);
	
    memcpy(UpuidDlg.chSoPin,OldSoPin.GetBuffer(0),16);
	
    memcpy(UpuidDlg.oldUserPin,Uid.GetBuffer(0),16);
	
	
    UpuidDlg.DoModal();
	
	UpdateData(FALSE);
	
}

HBRUSH CAboutDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if(::GetDlgCtrlID(pWnd->m_hWnd) ==IDC_STATIC5 )
	{
		pDC->SetTextColor(RGB(195,0,0));
	}
	if(::GetDlgCtrlID(pWnd->m_hWnd) ==IDC_STATIC6 )
	{
		pDC->SetTextColor(RGB(195,0,0));
	}
   	
	
	// TODO: Return a different brush if the default is not desired
	return hbr;
}

HBRUSH CSetSoPinDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	if(::GetDlgCtrlID(pWnd->m_hWnd) ==IDC_STATICWARING )
	{
		pDC->SetTextColor(RGB(255,0,0));
	}
	return hbr;
}

void CSetSoPinDlg::OnChangeOldpid() 
{
/*	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
	*/
	
	UpdateData(TRUE);
	Pid.Empty();
	memset(longPid, 0, 9);
	GetDlgItemText(EDIT_PID,Pid);              //ӲPID
	memcpy(longPid,Pid.GetBuffer(0),8);
	int PidLen = strlen((char*)longPid);

	if(PidLen == 8)
	{
		int tokenCount;
		unsigned long ret = ET_SUCCESS;
		unsigned char pucSN[8]={0};
		CString strtmp;
		CString strVal;
		
		ret = et_FindToken(longPid,&tokenCount);
		if(1 !=tokenCount || ET_SUCCESS != 0)
			return;	
		
		ret = et_OpenToken(&hET99,longPid,1);
		if(ET_SUCCESS != ret)
			return;
		
		//ȡӲк
		ret = et_GetSN(hET99, pucSN);
		if(ET_SUCCESS == ret)
		{
			strtmp.Empty();
			for(int i=0; i<8; i++)
			{
				strVal.Format(_T("%02X"), pucSN[i]);
				strtmp+=strVal;
			}
			GetDlgItem(IDC_EDIT_HID)->SetWindowText(strtmp);
			et_CloseToken(hET99);
		}
		
	}
	else
		GetDlgItem(IDC_EDIT_HID)->SetWindowText("");
}

void CSetSoPinDlg::OnChangeOlduid() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnChangeNewuid() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnChangeSopinSeed() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnChangeEditupinnum() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnCheckpidflg() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnChecksopinflg() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnCheckuserpin() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

void CSetSoPinDlg::OnCheckreadwflg() 
{
	b_newUserPin=TRUE;
	b_pidSeed=TRUE;
	b_sopinSeed=TRUE;
	b_num=TRUE;
	b_all=FALSE;
	UpdateData(TRUE);
	if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
		b_all=FALSE;
	else
		b_all=TRUE;
	
	if(m_upinflg)
	{
		if(16!=m_newupin.GetLength())
			b_newUserPin=FALSE;
		else
			b_newUserPin=TRUE;
	}
	if(m_pidflg)
	{
		if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
			b_pidSeed=FALSE;
		else
			b_pidSeed=TRUE;
	}
	if(m_sopinflg)
	{
		if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
			b_sopinSeed=FALSE;
		else
			b_sopinSeed=TRUE;
	}
	if(m_readwflg)
	{
		if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
			b_num=FALSE;
		else
			b_num=TRUE;
	}
	
	if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		m_btnSet.EnableWindow(FALSE);
	else
		m_btnSet.EnableWindow(TRUE);
	UpdateData(FALSE);
}

LRESULT CSetSoPinDlg::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	CString strError = "";
	CString strUSBInfo = "";
	int j = 0;
	
	switch (message)
    {
	case WM_DEVICECHANGE:
		//char szMsg[256] = {0};
		
		
		PDEV_BROADCAST_DEVICEINTERFACE pdbch = (PDEV_BROADCAST_DEVICEINTERFACE)lParam;
		switch (wParam)
		{
		case DBT_DEVICEARRIVAL:
			if (pdbch != NULL &&
				pdbch->dbcc_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
			{
				//sprintf(szMsg, "%s  Insert ", pdbch->dbcc_name);  
				//MessageBox(szMsg, "WM_DEVICECHANGE", MB_OK);
				
				strUSBInfo.Empty();
				strUSBInfo.Format("%s",pdbch->dbcc_name);
			}
			
			strUSBInfo.MakeUpper();  //ַתΪд֧win7.
			//ET99USBעϢУVIDΪ096ePIDΪ0303
			if((strUSBInfo.Find("096E") >= 0) && (strUSBInfo.Find("0303") >= 0))
			{
				m_List.ResetContent();
				m_List.AddString("ET99...");
				UpdateWindow();
				if(m_Batchflg)
				{
					Sleep(1000);
					CSetSoPinDlg::ET99batch();
				}
			}
			break;
			
		case DBT_DEVICEREMOVECOMPLETE:
			// See if a CD-ROM was removed from a drive.
			if (pdbch != NULL &&
				pdbch->dbcc_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
			{
				//sprintf(szMsg, "%s  Remove ", pdbch->dbcc_name);  
				//MessageBox(szMsg, "WM_DEVICECHANGE", MB_OK);
				
				strUSBInfo.Empty();
				strUSBInfo.Format("%s",pdbch->dbcc_name);
				m_List.ResetContent();
				GetDlgItem(IDC_EDIT_HID)->SetWindowText("");
				m_List.AddString("ET99Ƴ...");
			}
			
			strUSBInfo.MakeUpper();  //ַתΪд֧win7.
			if((strUSBInfo.Find("096E") >= 0) && (strUSBInfo.Find("0303") >= 0))
			{
				//MessageBox(strUSBInfo);
				//MessageBox("ET99 Remove");
				
				/*g_res=0;			
				if(!GetExitCodeProcess(g_pi.hProcess, &g_res))
				{
			}*/
				
				//if(!TerminateProcess(g_pi.hProcess,g_res))
				if(!TerminateProcess(g_pi.hProcess,0))
				{
				}
				
			}
			
			
			break;
			
		case DBT_DEVNODES_CHANGED:
			if (pdbch != NULL &&
				pdbch->dbcc_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
			{
				//sprintf(szMsg, "%s  Change ", pdbch->dbcc_name);  
				//MessageBox(szMsg, "WM_DEVICECHANGE", MB_OK);
			}
			break;
		}
	}
	
	return CDialog::DefWindowProc(message, wParam, lParam);
}

void CSetSoPinDlg::OnBatch() 
{
	if(m_Batchflg)
		IsBatch(FALSE);
	else
		IsBatch(TRUE);
}

void CSetSoPinDlg::IsBatch(BOOL bBatch)
{
	if(bBatch)
	{
		m_Batchflg = TRUE;
		m_btnSet.EnableWindow(FALSE);
		SetDlgItemText(BUTTON_SET, "..");
	}
	else
	{
		m_Batchflg = FALSE;
		m_btnSet.EnableWindow(TRUE);
		SetDlgItemText(BUTTON_SET, " ");
		
	}
}

void CSetSoPinDlg::ET99batch()
{
	m_List.ResetContent();
	if(m_Batchflg)
	{
		char chSoPin[17];
		unsigned char newPid[8];
		unsigned long ret = ET_SUCCESS;
		
		b_newUserPin=TRUE;
		b_pidSeed=TRUE;
		b_sopinSeed=TRUE;
		b_num=TRUE;
		b_all=FALSE;
		UpdateData(TRUE);
		if((m_oldpid.GetLength()!=8)||(m_olduid.GetLength()!=16)||m_oldpin.GetLength()!=16)
			b_all=FALSE;
		else
			b_all=TRUE;
		
		if(m_upinflg)
		{
			if(16!=m_newupin.GetLength())
				b_newUserPin=FALSE;
			else
				b_newUserPin=TRUE;
		}
		if(m_pidflg)
		{
			if((0==m_seed.GetLength())||(m_seed.GetLength()>51))
				b_pidSeed=FALSE;
			else
				b_pidSeed=TRUE;
		}
		if(m_sopinflg)
		{
			if((0==m_SopinSeed.GetLength())||(m_SopinSeed.GetLength()>51))
				b_sopinSeed=FALSE;
			else
				b_sopinSeed=TRUE;
		}
		if(m_readwflg)
		{
			if((GetDlgItemInt(IDC_EDITSOPINNUM)>15)||(GetDlgItemInt(IDC_EDITSOPINNUM)<0)||(GetDlgItemInt(IDC_EDITUPINNUM)>15)||(GetDlgItemInt(IDC_EDITUPINNUM)<0))
				b_num=FALSE;
			else
				b_num=TRUE;
		}
		
		if((!b_all)||(!b_newUserPin)||(!b_pidSeed)||(!b_sopinSeed)||(!b_num))
		{
			MessageBox("ѡȷдϢ!");
			return;
		}
		UpdateData(FALSE);
		
		if(m_sopinflg)
		{
			if(m_SopinSeed == m_seed)
			{
				if(IDYES!=MessageBox("PIDӺͲSOPINһ,ڰȫ!Ƿ?","InitET99",MB_YESNO))
					return;
			}
		}	
		
		//===========
		
		UpdateData(TRUE);
		// YUHZ[11/27/2006] ע⣡ڲSOPINPIDӦòͬήͰȫԡӦ 
		GetDlgItemText(EDIT_PID,Pid);              //ӲPID
		GetDlgItemText(EDIT_OLDSOPIN,OldSoPin);    //SOPIN
		GetDlgItemText(EDIT_SEED,Seed);            //
		GetDlgItemText(EDIT_OLDUID,Uid);           //ɵû
		GetDlgItemText(EDIT_NEWUID,NewUid);        //µû
		
		memcpy(longPid,Pid.GetBuffer(0),8);
		
		//ϴβµSO PIN µPID
		//	m_newsopin.Empty();
		//	m_newpid.Empty();
		UpdateData(FALSE);
		
		if(m_pidflg || m_sopinflg || m_upinflg ||  m_readwflg)
		{
			//========================ӲPID
			if(m_pidflg)
			{
				if(!OpenDevice())
				{
					return;
				}
				
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","SetTokenPID",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				ret = et_GenPID(hET99,Seed.GetLength(),(unsigned char *)Seed.GetBuffer(0),newPid);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ӲPIDʧ!","SetTokenPID",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{
					char NewChPid[9];
					memcpy(NewChPid,newPid,8);
					//µӲPIDֵ
					memcpy(longPid,newPid,8);
					NewChPid[8]='\0';
					CString CSPid(NewChPid);
					
					//дINIļ			
					fileini.WriteKeyVar("ET99","PID",Seed);
					fileini.WriteKeyVar("ET99","ӲPID",CSPid);
					
					strtmp.Format(">ӲPIDɹ! PID:%s\n", CSPid);
					//SetDlgItemText(IDC_Result, strtmp);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
				}
			}
			
			//=====================================
			
			//================óûPIN
			if(m_sopinflg )
			{
				if(!OpenDevice())
				{
					return;
				}
				
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","OpenEt99",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				ret = et_GenSOPIN(hET99,m_SopinSeed.GetLength(),(unsigned char *)m_SopinSeed.GetBuffer(0),(unsigned char*)chSoPin);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("óûPINʧ!","SetSOPIN",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{   
					chSoPin[16]='\0'; 
					//µSOPIN 
					OldSoPin=chSoPin;
					CString NewSoPin((char *)chSoPin);
					//strtmp.Format("");
					//SetDlgItemText(EDIT_NEWSOPIN,NewSoPin);
					strtmp.Format(">SOPINɹ! SOPIN: %s\n", NewSoPin);
					//SetDlgItemText(IDC_Result, strtmp);
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
					
					//дINIļ				
					fileini.WriteKeyVar("ET99","SOPIN",m_SopinSeed);
					fileini.WriteKeyVar("ET99","SO PIN",NewSoPin);
					
					//MessageBox("óûPINɹ ! ","SetSOPIN",MB_OK|MB_ICONINFORMATION);
				}
				
			}
			
			//==================================
			
			//=================ûPIN
			if(m_upinflg )
			{
				if(!OpenDevice())
				{
					return;
				}
				//			// YUHZ[11/27/2006] ƣet_ChangeUserPIN״̬½УҪ֤ûPIN 
				//			//֤û
				//			ret = et_Verify(hET99,ET_VERIFY_USERPIN,(unsigned char *)Uid.GetBuffer(0));
				//			if(ET_SUCCESS!=ret)
				//			{
				//				MessageBox("ûPIN!","UpUserPIN",MB_OK|MB_ICONSTOP);		
				//				et_CloseToken(hET99);
				//			}
				//			else
				{
					ret = et_ChangeUserPIN(hET99,(unsigned char *)Uid.GetBuffer(0),(unsigned char *)NewUid.GetBuffer(0));
					
					if(ET_SUCCESS!=ret)
					{
						if(ret == ET_NOT_SET_PID)
							MessageBox("㻹ûET99PID!","ChangeUserPin",MB_OK|MB_ICONSTOP);
						else
							MessageBox("ıûPIN!","ChangeUserPin",MB_OK|MB_ICONSTOP);
						et_CloseToken(hET99);
						return;
					}
					
					//дINIļ				
					fileini.WriteKeyVar("ET99","µUser PIN",NewUid);
					
					//MessageBox("ıûPINɹ!","ChangeUserPin",MB_OK);
					strtmp.Format(">ıûPINɹ! ûPIN: %s\n", NewUid);
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);			
				}
				
			}
			
			//==================================
			
			//================
			if(m_readwflg)
			{
				if(!OpenDevice())
				{
					return;
				}
				ret = et_Verify(hET99,ET_VERIFY_SOPIN,(unsigned char *)OldSoPin.GetBuffer(0));
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ûPIN!","OpenEt99",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				
				BYTE SoPinRetryCount=0;       //SOPINĶд
				BYTE UserPinRetryCount=0;     //UIDĶд
				BOOL ReadOnlyFlag=0;          //ֻ
				
				UpdateData(TRUE);
				
				
				SoPinRetryCount=atoi(m_sopinnum);
				UserPinRetryCount=atoi(m_upinnum);
				ReadOnlyFlag=m_readw;
				
				if(ReadOnlyFlag) ReadOnlyFlag=ET_USER_READ_ONLY; //ֻ
				
				if((0>SoPinRetryCount)||(15<SoPinRetryCount)||(0>UserPinRetryCount)||(15<UserPinRetryCount)||!(ReadOnlyFlag==0||ReadOnlyFlag==1))
				{
					MessageBox("д!","SetupToken",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				ret = et_SetupToken(hET99,SoPinRetryCount,UserPinRetryCount,ReadOnlyFlag,0);
				if(ET_SUCCESS!=ret)
				{
					MessageBox("ET99ʧ!","SetupToken",MB_OK|MB_ICONSTOP);
					et_CloseToken(hET99);
					return;
				}
				else
				{
					char sopincount[5]={0};
					char userpincount[5]={0};
					sprintf(sopincount,"%d",SoPinRetryCount);
					sprintf(userpincount,"%d",UserPinRetryCount);
					fileini.WriteKeyVar("ET99","SO PINԴ",sopincount);
					fileini.WriteKeyVar("ET99","User PINԴ",userpincount);
					if(m_readw)
						fileini.WriteKeyVar("ET99","д","ֻ");
					else
						fileini.WriteKeyVar("ET99","д","ɶд");
					//MessageBox("ET99Գɹ! ","SetupToken",MB_OK|MB_ICONINFORMATION);
					strtmp.Format(">ET99Գɹ!\n");
					Sleep(500);
					m_List.AddString(strtmp);
					UpdateWindow();
					et_CloseToken(hET99);
				}
			}
			//====================================
			Sleep(500);
			m_List.AddString("ET99óɹ! ...");
//			UpdateWindow();
	}
	else
	{
		MessageBox("ѡ!","Et99 Setting",MB_OK|MB_ICONINFORMATION);
		return ;
	}
}
}

BOOL CSetSoPinDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	{
		m_tooltip.RelayEvent(pMsg);
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CSetSoPinDlg::ToolTips()
{
	m_tooltip.Create(this);
	m_tooltip.Activate(TRUE);
	
	//////////////////////////////////////////////////////////////////////////
	m_tooltip.AddTool(GetDlgItem(EDIT_OLDPID), "PID8λĬΪ8F");  //old pid
	m_tooltip.AddTool(GetDlgItem(EDIT_OLDSOPIN), "ĹԱ룬16λĬΪ16F"); //old so pin
	m_tooltip.AddTool(GetDlgItem(EDIT_OLDUID), "ͨû룬16λĬΪ16F"); //old user pin

	m_tooltip.AddTool(GetDlgItem(EDIT_NEWUID), "µͨû룬ȱ16λַֻ0-9A-F(a-f)ϡ"); //new user pin
	m_tooltip.AddTool(GetDlgItem(EDIT_SEED), "ڲPID(ӲID)ӣ51ֽڡĸ֡źͺ֡"); //pid seed
	m_tooltip.AddTool(GetDlgItem(EDIT_SOPIN_SEED), "ڲԱӣ51ֽڡĸ֡źͺ֡"); //so pin seed

	m_tooltip.AddTool(GetDlgItem(IDC_CHECKREADW), "洢Ķд־ѡͨûֻܶдԱơ"); //ֻ־
	m_tooltip.AddTool(GetDlgItem(IDC_EDITSOPINNUM), "Ա(SO PIN)ԴΧ0-150ƣ޴ԡ"); //so pinԴ
	m_tooltip.AddTool(GetDlgItem(IDC_EDITUPINNUM), "ͨû(User PIN)ԴΧ0-150ƣ޴ԡ"); //user pinԴ
	
	m_tooltip.AddTool(GetDlgItem(IDC_CHECKPIDFLG), "ѡòµPID");  //
	m_tooltip.AddTool(GetDlgItem(IDC_CHECKSOPINFLG), "ѡòµĹԱ(SO PIN)");  //
	m_tooltip.AddTool(GetDlgItem(IDC_CHECKUSERPIN), "ѡͨû(User PIN)");  //
	m_tooltip.AddTool(GetDlgItem(IDC_CHECKREADWFLG), "ѡ[ֻ־][Դ]");  //

	m_tooltip.AddTool(GetDlgItem(IDC_Batch), "ѡԶãҪǰ᣺дøϢҪڽдʼ֧ѡ");  //
	m_tooltip.AddTool(GetDlgItem(IDC_LIST_RESULT), "õĽϸϢʷ¼鿴");  //
	
	m_tooltip.AddTool(GetDlgItem(BUTTON_SET), "ʼ");  //
	m_tooltip.AddTool(GetDlgItem(IDC_BUTHOISTRY), "ʷ¼");  //
	m_tooltip.AddTool(GetDlgItem(BUTTON_RESET2), "޸һ֧ET99User PIN룬ҪSO PIN롣");  //
	m_tooltip.AddTool(GetDlgItem(IDC_EDIT_HID), "ӲPIDȷʱ˴ʾǰET99Ӳкš");  //

	//////////////////////////////////////////////////////////////////////////
	m_tooltip.SetTipTextColor(RGB(0,0,255)); //趨ֵɫ
	m_tooltip.SetDelayTime(150);  //ʾϢʾʱʱ
	m_tooltip.SetDelayTime(TTDT_AUTOPOP, 20000); //ʾϢͣʱ
}
